#define vec2 float2
#define vec3 float3
#define vec4 float4
#define rgb xyz
#define rgba xyzw

const sampler_t sampler = CLK_NORMALIZED_COORDS_TRUE | CLK_ADDRESS_CLAMP_TO_EDGE | CLK_FILTER_LINEAR;

float random( vec2 c )
{
    float itpr = 0.0f;
	return fract(sin( dot( c.xy, (vec2)( 12.9898f, 78.233f))) * 43758.5453f,&itpr);
}

float noise ( vec2 uv) {
    vec2 i = floor(uv);
    vec2 itpr = (vec2)(0.0f);
    vec2 f = fract(uv,&itpr);    
    float a = random(i);
    float b = random(i + (vec2)(1.0f, 0.0f));
    float c = random(i + (vec2)(0.0f, 1.0f));
    float d = random(i + (vec2)(1.0f, 1.0f));
    vec2 u = f * f * (3.0f - 2.0f * f);
    return mix(a, b, u.x) + 
            (c - a)* u.y * (1.0f - u.x) + 
            (d - b) * u.x * u.y;
}

float Warping ( vec2 uv,int Strength) {
    int numOctaves = Strength;
    
    float v = 0.0f;
    float a = 0.5f;
    vec2 shift = (vec2)(100.0f);    
    for(int i =0;i<numOctaves;i++){
        v += a * noise(uv);
        uv = (vec2)(cos(0.5f)*uv.x + (-sin(0.5f))*uv.y , sin(0.5f)*uv.x + cos(0.50f)*uv.y) * 2.0f + shift;
        a *= 0.5f;
    }   
    return v;
}

__kernel void MAIN(
      __read_only image2d_t input,    
      __write_only image2d_t dest_data,
      __global FilterParam* param,
	  int alpha,
      int Strength) 
{
    int outputW = param->width[1];
	int outputH = param->height[1];
    int W = get_global_size(0);
	int H = get_global_size(1);
    float2 ouputResolution = (float2)(W,H);  
    int2 gl_FragCoord = (int2)(get_global_id(0), get_global_id(1));

    vec2 fragCoord = (vec2)(get_global_id0( param), get_global_id1( param));
    vec2 resolution = ouputResolution;
	vec2 tc = ((float2)(fragCoord.x, fragCoord.y) + (vec2)(0.5f))/ouputResolution.xy;

    vec2 uv = (float2)(tc.x, tc.y)*(vec2)(param->origROI[2], param->origROI[3]) + (vec2)(param->origROI[0], param->origROI[1]);

    float4 orig = read_imagef(input, sampler, uv);     
    
    float fragX = (float)(get_global_id(0) - get_global_offset(0));
    float fragY = (float)(get_global_id(1) - get_global_offset(1));
    vec2 frag = (vec2)(fragX,fragY);
	
    float time = param->cur_time * 2.0f;

    vec2 p = ( 2.0f * frag - resolution.xy ) / resolution.x * 1000.0f;
    vec4 inputColor = orig;   
    
     vec2 st = frag.xy/resolution.xy*3.0f;
   
    vec3 color = (vec3)(0.0f);

    vec2 q = (vec2)(0.0f);
    q.x = Warping( st + 0.00f*time,Strength);
    q.y = Warping( st + (vec2)(1.0f),Strength);

    vec2 r = (vec2)(0.0f);
    r.x = Warping( st + 1.0f*q + (vec2)(1.7f,9.2f)+ 0.15f*time ,Strength);
    r.y = Warping( st + 1.0f*q + (vec2)(8.3f,2.8f)+ 0.126f*time,Strength);

    float f = Warping(st+r,Strength);

    color = mix((vec3)(0.101961f,0.619608f,0.666667f),
                (vec3)(0.666667f,0.666667f,0.498039f),
                clamp((f*f)*4.0f,0.0f,1.0f));

    color = mix(color,
                (vec3)(0.0f,0.0f,0.164706f),
                clamp(length(q),0.0f,1.0f));

    color = mix(color,
                (vec3)(0.666667f,1.0f,1.0f),
                clamp(length(r.x),0.0f,1.0f));

    vec4 fragColor = (vec4)((f*f*f+0.6f*f*f+0.5f*f)*color,1.0f);
	
    fragColor.xyz = 1.0f - (1.0f - inputColor.xyz)*(1.0f-fragColor.xyz);
       
    vec4 retColor =  mix( fragColor, orig, 1.0f - (float)(alpha)/100.0f ); 
    write_imagef(dest_data,gl_FragCoord,retColor);
}



